import { BrowserRouter, Routes, Route } from 'react-router-dom';
import RequireAuth from './components/login/RequireAuth';
import Dashboard from './Dashboard';
import Login from './components/login/Login';
import { Navigation } from './navigation/Navigation';
import Report  from './report/Report';


export default function App() {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/" element={<Login />} />

        {/* Protected Route */}
        <Route
          path="/navigation"
          element={
            <RequireAuth>
              <Navigation />
            </RequireAuth>
          }
        />

        <Route
          path="/dashboard"
          element={
            <RequireAuth>
              <Dashboard />
            </RequireAuth>
          }
        />

        <Route
          path="/report"
          element={
            <RequireAuth>
              <Report />
            </RequireAuth>
          }
        />

      </Routes>
    </BrowserRouter >
  );
}
